package eu.europa.ec.healtheid.repository;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.NoSuchElementException;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import eu.europa.ec.healtheid.models.Encounter;
import eu.europa.ec.healtheid.utils.JwtTokenUtils;

@RunWith(SpringJUnit4ClassRunner.class)
@DataJpaTest
public class EncounterRepositoryTest {
	@Autowired
	private EncounterRepository encounterRepository;
	@Mock
    JwtTokenUtils jwtTokenUtils;
	
	@Test
    public void store_and_update_Encounter() {
        Encounter encounter = new Encounter();
    	Mockito.when(jwtTokenUtils.createToken(encounter)).thenReturn("aaa.bbb.ccc");
    	
        encounter.setToken(jwtTokenUtils.createToken(encounter));
        encounter.setPatientEmail("john@test.com");
        encounter.setPatientMobilePhone("+39 345 1256789");
        encounter.setConsent(false);
        Encounter e1 =encounterRepository.save(encounter);
 
        assertNotNull(encounterRepository.findById(encounter.getToken()).get());
        assertFalse(e1.isConsent());
        
        encounter.setConsent(true);
        encounterRepository.save(encounter);
        e1 = encounterRepository.findById(encounter.getToken()).get(); 
    	assertEquals("The encounterID is not correctly stored in the DB",encounter.getToken(), e1.getToken());
    	assertEquals("The Patient country code is not correctly stored in the DB",encounter.getPatientCountryCode(), e1.getPatientCountryCode());
    	assertEquals("The patient email is not correctly stored in the DB",encounter.getPatientEmail(), e1.getPatientEmail());
    	assertEquals("The patient mobile phone is not correctly stored in the DB",encounter.getPatientMobilePhone(), e1.getPatientMobilePhone());
    	assertEquals("The java class encounter is not correctly stored in the DB",encounter.getClass(), e1.getClass());
    	assertTrue(e1.isConsent());
    }
    
	@Test(expected = NoSuchElementException.class)
    public void delete_from_EncounterRepository() {
    	Encounter encounter = new Encounter();
     	Mockito.when(jwtTokenUtils.createToken(encounter)).thenReturn("aaa.bbb.ccc");
     	
        encounter.setToken(jwtTokenUtils.createToken(encounter));
        encounter.setPatientEmail("john@test.com");
        encounter.setPatientMobilePhone("+39 345 1256789");
        encounter.setConsent(false);
        Encounter e1 =encounterRepository.save(encounter);
  
        assertNotNull(encounterRepository.findById(encounter.getToken()).get());
        assertFalse(e1.isConsent());
        //delete the value
        encounterRepository.deleteById(encounter.getToken());
        //try to retrieve deleted value: it will raise an exception
        encounterRepository.findById(encounter.getToken()).get();        
    }
    
	
}
