package eu.europa.ec.healtheid.repository;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;
import java.util.NoSuchElementException;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import eu.europa.ec.healtheid.models.Encounter;
import eu.europa.ec.healtheid.models.PatientAcknowledge;
import eu.europa.ec.healtheid.utils.JwtTokenUtils;

@RunWith(SpringJUnit4ClassRunner.class)
@DataJpaTest
public class AcknowledgeRepositoryTest {
	
	@Autowired
    private AcknowledgeRepository acknowledgeRepository;
	@Mock
    JwtTokenUtils jwtTokenUtils;

	 @Test
	    public void store_and_update_Acknowledge() {
	    	Encounter encounter = new Encounter();
	    	Mockito.when(jwtTokenUtils.createToken(encounter)).thenReturn("aaa.bbb.ccc");
	        
	    	String encounterID = jwtTokenUtils.createToken(encounter);
	    	String PINReference = "Patient Information Notice";
	    	 	
	        encounter.setToken(encounterID);
	        encounter.setPatientEmail("john@test.com");
	        encounter.setPatientMobilePhone("+39 345 1256789");
	        encounter.setConsent(false);
	                  
	        PatientAcknowledge consent = new PatientAcknowledge();
	        consent.setConsent(false);
	        consent.setJWTtoken(encounterID);
	        Date timestamp=new Date(System.currentTimeMillis());
	        consent.setTimestamp(timestamp);
	        consent.setPIN(PINReference);     
	        acknowledgeRepository.save(consent);
	        
	        PatientAcknowledge ack=acknowledgeRepository.findById(encounterID).get();
	        assertNotNull("the ack in db cannot be null",ack);
	    	assertNotNull("Token cannot be null", ack.getJWTtoken());
	    	assertNotNull("PIN cannot be null", ack.getPIN());
	    	assertNotNull("Timestamp cannot be null", ack.getTimestamp());
	    	assertNotNull("Consent cannot be null", ack.isConsentGiven());
	    	
	    	assertEquals(encounterID,ack.getJWTtoken());
	    	assertEquals(PINReference,ack.getPIN());
	    	assertFalse("The consent has to be set to false", ack.isConsentGiven());
	    	assertEquals(timestamp,ack.getTimestamp());
	                
	        //Update consent and timestamp 
	        ack.setConsent(true);
	        timestamp=new Date(System.currentTimeMillis());
	        ack.setTimestamp(timestamp);
	        ack=acknowledgeRepository.save(ack);
	        assertTrue("The consent has to be set to true", ack.isConsentGiven()); 
	        assertEquals(timestamp,ack.getTimestamp());   
	    }
	 
	 @Test(expected = NoSuchElementException.class)
	    public void delete_from_AcknowledgeRepository() {
	    	Encounter encounter = new Encounter();
	    	Mockito.when(jwtTokenUtils.createToken(encounter)).thenReturn("aaa.bbb.ccc");
	        
	    	String encounterID = jwtTokenUtils.createToken(encounter);
	    	String PINReference = "Patient Information Notice";
	    	 	
	        encounter.setToken(encounterID);
	        encounter.setPatientEmail("john@test.com");
	        encounter.setPatientMobilePhone("+39 345 1256789");
	        encounter.setConsent(false);
	                  
	        PatientAcknowledge consent = new PatientAcknowledge();
	        consent.setConsent(false);
	        consent.setJWTtoken(encounterID);
	        Date timestamp=new Date(System.currentTimeMillis());
	        consent.setTimestamp(timestamp);
	        consent.setPIN(PINReference);     
	        acknowledgeRepository.save(consent);
	        //delete the value
	        acknowledgeRepository.deleteById(consent.getJWTtoken());
	        //try to retrieve deleted value: it will raise an exception
	        acknowledgeRepository.findById(consent.getJWTtoken()).get();
	    }
	    
}
