package eu.europa.ec.healtheid.mapper;

import eu.europa.ec.healtheid.adaptor.model.*;
import eu.europa.ec.healtheid.models.SearchFieldsForm;
import org.junit.Test;

import java.util.ArrayList;
import java.util.List;

import static org.junit.Assert.*;

public class HealtheidCountryConfigurationMapperTest {

    @Test
    public void searchFieldsToSearchFieldsForm() {
        HealtheidCountryConfiguration healtheidCountryConfiguration = new HealtheidCountryConfiguration();
        PatientSearch patientSearch = new PatientSearch();
        Country country = new Country();
        SearchFields searchFields = new SearchFields();
        country.setSearchFields(searchFields);
        patientSearch.setCountry(country);


        List<TextField> textFields = new ArrayList<>();
        TextField t1 = new TextField();
        t1.setLabel("Text Field 1 LB");
        TextField t2 = new TextField();
        t2.setFriendlyName("Text Field 2 FN");
        t2.setLabel("Text Field 2 LB");

        textFields.add(t1);
        textFields.add(t2);

        List<Id> ids = new ArrayList<>();
        Id i1 = new Id();
        i1.setFriendlyName("Id 1 FN");
        i1.setLabel("Id 1 LB");
        Id i2 = new Id();
        i2.setLabel("Id 2 LB");

        ids.add(i1);
        ids.add(i2);

        searchFields.setTextField(textFields);
        searchFields.setId(ids);

        healtheidCountryConfiguration.setPatientSearch(patientSearch);

        SearchFieldsForm searchFieldsForm = HealtheidCountryConfigurationMapper.searchFieldsToSearchFieldsForm(healtheidCountryConfiguration);

        assertNotNull(searchFields);
        assertEquals(searchFieldsForm.getTextFields().size(), 2);
        assertNotNull(searchFieldsForm.getTextFields().get("Text Field 1 LB"));
        assertNotNull(searchFieldsForm.getTextFields().get("Text Field 2 FN"));
        assertNull(searchFieldsForm.getTextFields().get("Text Field 2 LB"));

        assertEquals(searchFieldsForm.getIds().size(), 2);
        assertNotNull(searchFieldsForm.getIds().get("Id 1 FN"));
        assertNotNull(searchFieldsForm.getIds().get("Id 2 LB"));
        assertNull(searchFieldsForm.getIds().get("Id 1 LB"));


        searchFieldsForm = HealtheidCountryConfigurationMapper.searchFieldsToSearchFieldsForm(null);
        assertNull(searchFieldsForm);

    }
}
