package eu.europa.ec.healtheid.controllers;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.WebMvcTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.fasterxml.jackson.databind.ObjectMapper;

import eu.europa.ec.healtheid.exception.HealtheidGetCountryConfigurationException;
import eu.europa.ec.healtheid.management.WorkflowManager;
import eu.europa.ec.healtheid.models.Encounter;
import eu.europa.ec.healtheid.repository.AcknowledgeRepository;
import eu.europa.ec.healtheid.repository.EncounterRepository;
import eu.europa.ec.healtheid.repository.PatientDataRepository;
import eu.europa.ec.healtheid.security.JwtAuthenticationEntryPoint;
import eu.europa.ec.healtheid.services.NcpHProxyService;
import eu.europa.ec.healtheid.services.PatientConnector;
import eu.europa.ec.healtheid.utils.JwtTokenUtils;

import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;

import static eu.europa.ec.healtheid.config.HealtheidConnectorConstants.HEID_CONNECTOR_BASE_URL;
import static eu.europa.ec.healtheid.config.HealtheidConnectorConstants.HEID_CONNECTOR_CREATE_ENCOUNTER_URL;
import static org.junit.Assert.*;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

import javax.servlet.http.HttpServletRequest;

import static eu.europa.ec.healtheid.config.HealtheidConnectorConstants.*;


import org.junit.Before;

@RunWith(SpringRunner.class)
@WebMvcTest(EidasHProxyController.class)
public class EidasHProxyControllerTest {
	
	@SpyBean
    WorkflowManager workflowManager;

    @MockBean
    NcpHProxyService ncphproxy;

    @MockBean
    PatientConnector patientConnector;

    @MockBean
    AcknowledgeRepository acknowledgeRepository;

    @MockBean
    PatientDataRepository patientRepository;

    @MockBean
    EncounterRepository encounterRepository;


    @MockBean
	JwtAuthenticationEntryPoint unauthorizedHandler;
	
	@MockBean
	JwtTokenUtils jwtTokenUtils;

	@Autowired
	private MockMvc mockMvc;
	
	
	@Before
	public void setup () {
		when(jwtTokenUtils.validateToken(any(String.class))).thenReturn(true);
    }

    @Test
    public void acceptPatientAuthNData() throws Exception {
    	
    	String token = "aaa.bbb.ccc";
    	Map<String,String> eidasAttributes= new HashMap<>();
    	
    	eidasAttributes.put("GivenName", "John");
    	eidasAttributes.put("FamilyName", "Snow");
    	
    	String url=  EIDAS_PROXY_BASE_URL+EIDAS_PROXY_PATIENT_AUTH_URL;
   	  	 
    	mockMvc.perform(post(url)
    			.secure(true)
    		    .contentType(MediaType.APPLICATION_JSON)
    		    .content(asJsonString(eidasAttributes))
    			.header("Authorization", token)
    			.accept(MediaType.TEXT_PLAIN_VALUE))
    	.andExpect(status().isOk());
    	
    	Mockito.verify(workflowManager, times(1))
    					.processEncounterData(any(String.class),any(HttpServletRequest.class),
    							any(Map.class),any(RedirectAttributes.class));
    
    }
    
    public static String asJsonString(final Object obj) {
        try {
            final ObjectMapper mapper = new ObjectMapper();
            final String jsonContent = mapper.writeValueAsString(obj);
            System.out.println(jsonContent);
            return jsonContent;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
