package eu.europa.ec.healtheid.utils;

import eu.europa.ec.healtheid.models.SearchFieldsForm;

import java.util.Map;
import java.util.stream.Collectors;

public class SearchFieldsFormUtils {

    public static SearchFieldsForm prepareForView(SearchFieldsForm searchFieldsForm) {
        return replaceTextFieldAndIdsKey(searchFieldsForm," ", "_");
    }

    public static SearchFieldsForm processViewReturn(SearchFieldsForm searchFieldsForm) {
        return replaceTextFieldAndIdsKey(searchFieldsForm,"_", " ");
    }


    private static SearchFieldsForm replaceTextFieldAndIdsKey(SearchFieldsForm searchFieldsForm, String before, String after) {
        Map<String, String> textFields = searchFieldsForm.getTextFields().entrySet()
                .stream()
                .collect(Collectors.toMap(
                        e -> e.getKey().replaceAll(before, after),
                        Map.Entry::getValue

                ));
        Map<String, String> ids = searchFieldsForm.getIds().entrySet()
                .stream()
                .collect(Collectors.toMap(
                        e -> e.getKey().replaceAll(before, after),
                        Map.Entry::getValue
                ));

        searchFieldsForm.setTextFields(textFields);
        searchFieldsForm.setIds(ids);
        return searchFieldsForm;
    }
}
