package eu.europa.ec.healtheid.services;

import eu.europa.ec.healtheid.models.enumerator.NotificationType;
import eu.europa.ec.healtheid.notification.adapter.model.HealtheidNotification;
import eu.europa.ec.healtheid.notification.adapter.service.HealtheidNotifier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Class for connecting to Patient
 *
 * @author Giuseppe Burrai - Politecnico di Torino
 */
@Component
public class PatientConnectorImpl implements PatientConnector {

    private static final Logger LOGGER = LoggerFactory.getLogger(PatientConnectorImpl.class);

    @Autowired
    private HealtheidNotifier healtheidNotifier;


    @Override
    public boolean sendLinkToPatient(String link, String phoneOrEmail) {
        HealtheidNotification healtheidNotification = new HealtheidNotification();
        healtheidNotification.setMessage("To initiate the clinical encounter please click here: " + link);
        if (phoneOrEmail.contains("@")) {
            LOGGER.info("send email to: " + phoneOrEmail);
            healtheidNotification.setTitle("Encounter request from HeiD Services");
            healtheidNotification.setEmail(phoneOrEmail);
        } else {
            if (StringUtils.isNumeric(phoneOrEmail)) {
                healtheidNotification.setSms(phoneOrEmail);
            }
        }
        healtheidNotifier.notify(healtheidNotification);

        if (!healtheidNotification.isNotificationSent()){
            LOGGER.info("Unable to send the notification");
        }
        
        return healtheidNotification.isNotificationSent();
    }

    @Override
    public boolean sendNotificationToPatient(NotificationType type, String phoneOrEmail) {
        HealtheidNotification healtheidNotification = new HealtheidNotification();
        healtheidNotification.setMessage("HeiD Services: Notification of document access" );
        if (phoneOrEmail.contains("@")) {
            healtheidNotification.setTitle("HeiD Services: Document accessed");
            healtheidNotification.setEmail(phoneOrEmail);
        } else {
            if (StringUtils.isNumeric(phoneOrEmail)) {
                healtheidNotification.setSms(phoneOrEmail);
            }
        }
        healtheidNotifier.notify(healtheidNotification);

        if (!healtheidNotification.isNotificationSent()){
            LOGGER.info("Unable to send the notification");
        }
        
        return healtheidNotification.isNotificationSent();
    }
}
