package eu.europa.ec.healtheid.services;

import org.springframework.stereotype.Component;

import eu.europa.ec.healtheid.models.enumerator.NotificationType;


/**
* Interface for connecting to Patient
* 
* @author Giuseppe Burrai - Politecnico di Torino
*
*/

@Component
public interface PatientConnector {
	
	/**
	 * Method responsible to send the link to patient
	 * 
	 * @param link generated by WM
	 * @param phoneOrEmail 
	 * 
	 */
	public boolean sendLinkToPatient(String link, String phoneOrEmail);
	
	public boolean sendNotificationToPatient(NotificationType type, String phoneOrEmail);
	
}
