package eu.europa.ec.healtheid.services;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import eu.europa.ec.healtheid.adaptor.model.HealtheidCountryConfiguration;
import eu.europa.ec.healtheid.exception.HealtheidGetCountryConfigurationException;

@Component
public class NcpHProxyServiceImpl implements NcpHProxyService {

	@Value("${ncphproxy.url}")
    private String ncphproxyUrl;
	
	@Override
	public HealtheidCountryConfiguration getCountryConfiguration(String country) throws HealtheidGetCountryConfigurationException {
		// CALL ENDPOINT NCPHPROXY
    	// /ncphproxy/country	
		RestTemplate restTemplate = new RestTemplate();	
		ResponseEntity<HealtheidCountryConfiguration> response = 
				restTemplate.getForEntity(ncphproxyUrl + "/"+country, HealtheidCountryConfiguration.class);
	
		if (response.getStatusCode()!=HttpStatus.OK)
			throw new HealtheidGetCountryConfigurationException("NcpHProxy responses with this status code: " + 
							response.getStatusCode());
		
		return response.getBody();
	}

}
