package eu.europa.ec.healtheid.services;

import org.springframework.stereotype.Component;

import eu.europa.ec.healtheid.adaptor.model.HealtheidCountryConfiguration;
import eu.europa.ec.healtheid.exception.HealtheidGetCountryConfigurationException;

/**
* Interface for connecting to NCP HProxy and get the Country Configuration
*
*/
@Component
public interface NcpHProxyService {

	/**
	 *
	 * Method that calls NCP HProxy component to discover the Country Configuration
	 * 
	 * @param the patient country value
	 * @throws HealtheidGetCountryConfigurationException - A problem occurs while retrieving the Country Conf from the NcpHProxy
	 */
	public HealtheidCountryConfiguration getCountryConfiguration(String country) throws HealtheidGetCountryConfigurationException;
	
}