package eu.europa.ec.healtheid.security.config;

import eu.europa.ec.healtheid.config.HealtheidConnectorConstants;
import eu.europa.ec.healtheid.security.JwtAuthenticationEntryPoint;
import eu.europa.ec.healtheid.security.JwtAuthenticationTokenFilter;

import static eu.europa.ec.healtheid.config.HealtheidConnectorConstants.HEID_CONNECTOR_BASE_URL;
import static eu.europa.ec.healtheid.config.HealtheidConnectorConstants.HEID_CONNECTOR_CREATE_ENCOUNTER_URL;
import static eu.europa.ec.healtheid.config.HealtheidConnectorConstants.PATIENT_BASE_URL;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled = true)
public class WebSecurityConfig extends WebSecurityConfigurerAdapter {
	
	@Autowired
	private JwtAuthenticationEntryPoint unauthorizedHandler;

	@Value("${server.ssl.enabled}")
    private Boolean secureEnabled;
	
	@Bean
	public JwtAuthenticationTokenFilter authenticationTokenFilterBean() throws Exception {
		return new JwtAuthenticationTokenFilter();
	}
	
	@Override
    protected void configure(HttpSecurity httpSecurity) throws Exception {
	    if (secureEnabled) httpSecurity.requiresChannel().anyRequest().requiresSecure();

		httpSecurity.csrf().disable()
        		.exceptionHandling()
        			.authenticationEntryPoint(unauthorizedHandler)
        			.and()
                .sessionManagement()
                	.sessionCreationPolicy(SessionCreationPolicy.STATELESS)
                	.and()
                .authorizeRequests()
	                .antMatchers(
	                        HttpMethod.GET,
	                        "/",
	                        "/*.html",
	                        "/favicon.ico",
	                        "/**/*.html",
	                        "/**/*.css",
	                        "/**/*.js",
	                        "/**/*.png"
	                ).permitAll()	                
	                .antMatchers(PATIENT_BASE_URL+"/**").permitAll()
	                .antMatchers(HEID_CONNECTOR_BASE_URL+HEID_CONNECTOR_CREATE_ENCOUNTER_URL).permitAll()
	                .anyRequest().authenticated()
	                .and()
	            .formLogin().disable()
                .httpBasic().disable();
        httpSecurity.addFilterBefore(authenticationTokenFilterBean(),BasicAuthenticationFilter.class);
        httpSecurity.headers().cacheControl();
    }
}
