package eu.europa.ec.healtheid.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;

import org.hibernate.annotations.Cascade;

/**
* This class represents the PatientData stored inside the HeiD Connector
*
*/
@Entity
public class PatientData implements Serializable {

	private static final long serialVersionUID = 5941358500572589245L;
	
	
	@Id
	private String encounterID;
	private boolean dataReady;

	@OneToMany(fetch = FetchType.EAGER, mappedBy = "patientData", cascade = { CascadeType.PERSIST, CascadeType.MERGE })
	@Cascade({ org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE })
	private List<Demographics> demographics;

	/** 
	 * Gets the encounterID aka JWT Token
	 */
	public String getEncounterID() {
		return encounterID;
	}
	
	/** 
	 * Sets the encounterID aka JWT Token
	 */
	public void setEncounterID(String encounterID) {
		this.encounterID = encounterID;
	}

	/** 
	 * Gets the boolean DataReady.
	 * If dataReady==true, the HeiD Connector is ready to send PatientData to HeiD Client
	 */
	public boolean dataIsReady() {
		return dataReady;
	}
	
	/**
	 * Sets the boolean DataReady.
	 * This action is made when all the Patient Information are available
	 * inside the HeiD Connector and they can be forwarded to the HeiD Client
	*/
	public void setDataReady(boolean value) {
		this.dataReady = value;
	}
	
	/**
     * Gets the value of the List of Demographics Objects.
     * 
     * To add a new item, do as follows:
     * <pre>
     *    getDemographics().add(newItem);
     * </pre>
     * 
     */
	public List<Demographics> getDemographics() {
		if (demographics == null) {
			demographics = new ArrayList<Demographics>();
		}
		return this.demographics;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((encounterID == null) ? 0 : encounterID.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		PatientData other = (PatientData) obj;
		if (encounterID == null) {
			if (other.encounterID != null)
				return false;
		} else if (!encounterID.equals(other.encounterID))
			return false;
		return true;
	}
}