package eu.europa.ec.healtheid.models;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
/**
* This class represents the PatientAcknowledge that will be stored inside the HeiD Connector
*
*/
@Entity 
@Table(name = "acknowledge")
public class PatientAcknowledge {
	
	@Id
	private String JWTtoken;
	private boolean consent;
	private Date timestamp;
	private String PINreference; 
	private String PatientID;
	
	public String getPatientID() {
		return PatientID;
	}
	public void setPatientID(String patientID) {
		PatientID = patientID;
	}
	
	/**
	 * Gets the Timestamp of GivenConsent Action
	 * */
	public Date getTimestamp() {
		return timestamp;
	}
	
	/**
	 * Sets the Timestamp of GivenConsent Action
	 * */
	public void setTimestamp(Date timestamp) {
		this.timestamp = timestamp;
	}
	
	/** 
	 * Gets the Patient Information Notice Reference
	 */
	public String getPIN() {
		return PINreference;
	}
	
	/** 
	 * Sets the Patient Information Notice Reference
	 */
	public void setPIN(String PINversion) {
		this.PINreference = PINversion;
	}
	
	/** 
	 * Gets the encounterID aka JWT Token
	 */
	public String getJWTtoken() {
		return JWTtoken;
	}
	
	/** 
	 * Sets the encounterID aka JWT Token
	 */
	public void setJWTtoken(String jWTtoken) {
		JWTtoken = jWTtoken;
	}
	/**
	 * Check if patient has given your consent
	 * */
	public boolean isConsentGiven() {
		return consent;
	}
	/**
	 * Sets patient consent
	 * */
	public void setConsent(boolean consent) {
		this.consent = consent;
	}
}
