package eu.europa.ec.healtheid.models;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Id;

/**
* This class represents the Encounter between the Healthcare Professional and the Patient
*/
@Entity
public class Encounter implements Serializable {

    private static final long serialVersionUID = -3279575358846693816L;
    private String patientEmail;	
    private String patientMobilePhone;
    private String patientCountryCode;
    @Id
    private String token;

    private boolean consent;

    /** 
   	 * Gets the Patient Country Code
   	 */
    public String getPatientCountryCode() {
        return patientCountryCode;
    }

    public void setPatientCountryCode(String patientCountryCode) {
        this.patientCountryCode = patientCountryCode;
    }

    /** 
   	 * Gets the email of the Patient
   	 */
    public String getPatientEmail() {
        return patientEmail;
    }

    public void setPatientEmail(String patientEmail) {
        this.patientEmail = patientEmail;
    }

    /** 
   	 * Gets the MobilePhone of the Patient
   	 */
    public String getPatientMobilePhone() {
        return patientMobilePhone;
    }

    public void setPatientMobilePhone(String patientMobilePhone) {
        this.patientMobilePhone = patientMobilePhone;
    }

    /** 
   	 * Gets the encounterID aka JWT Token
   	 */
    public String getToken() {
        return token;
    }
    /** 
   	 * Sets the encounterID aka JWT Token
   	 */
    public void setToken(String token) {
        this.token = token;
    }

    public boolean isConsent() {
        return consent;
    }

    public void setConsent(boolean consent) {
        this.consent = consent;
    }
}
