package eu.europa.ec.healtheid.mapper;

import eu.europa.ec.healtheid.adaptor.model.HealtheidCountryConfiguration;
import eu.europa.ec.healtheid.adaptor.model.SearchFields;
import eu.europa.ec.healtheid.models.SearchFieldsForm;

import java.util.HashMap;
import java.util.Map;

public class HealtheidCountryConfigurationMapper {


    /**
     * This method will create a searchFieldsForm based on the healtheidCountryConfiguration SearchField object
     * If HealtheidCountryConfiguration has  friendlyName it will use it as key else it will use the label
     * @param healtheidCountryConfiguration
     * @return SearchFieldsForm
     */
    public static SearchFieldsForm searchFieldsToSearchFieldsForm(HealtheidCountryConfiguration healtheidCountryConfiguration){
        SearchFields searchFields;
        try {
            searchFields = healtheidCountryConfiguration.getPatientSearch().getCountry().getSearchFields();
        } catch (NullPointerException npe) {
            return null;
        }
        Map<String, String>  textFields = new HashMap<>();
        Map<String, String>  ids = new HashMap<>();

        if (searchFields.getTextField() != null && !searchFields.getTextField().isEmpty())
        searchFields.getTextField().
                forEach(textField -> {
                    String key = textField.getLabel();
                    if (textField.getFriendlyName() != null && !textField.getFriendlyName().isEmpty()) key = textField.getFriendlyName();
                    textFields.put(key,"");
                });

        if (searchFields.getId() != null && !searchFields.getId().isEmpty())
        searchFields.getId().
                forEach(id -> ids.put((id.getFriendlyName() != null && !id.getFriendlyName().isEmpty()) ? id.getFriendlyName() : id.getLabel(),""));



        SearchFieldsForm searchFieldsForm = new SearchFieldsForm();
        searchFieldsForm.setIds(ids);
        searchFieldsForm.setTextFields(textFields);
        if (searchFields.getBirthDate() != null )searchFieldsForm.setBirthDate("");
        if (searchFields.getSex() != null )searchFieldsForm.setSex("");

        return searchFieldsForm;
    }


}
