package eu.europa.ec.healtheid.controllers;

import eu.europa.ec.healtheid.exception.HealtheidGetCountryConfigurationException;
import eu.europa.ec.healtheid.management.WorkflowManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

import static eu.europa.ec.healtheid.config.HealtheidConnectorConstants.*;

/**
* This Controller manages the eidasHProxy responses, after the eIDAS authentication of the Patient
* All the Exceptions are handled by HealtheidExceptionHandler.class in eu.europa.ec.healtheid.config
* 
* @author Giuseppe Burrai - Politecnico di Torino
*
*/

@Controller
@RequestMapping(EIDAS_PROXY_BASE_URL)
public class EidasHProxyController {
	
	@Autowired
	WorkflowManager workflowManager;
	
	/**
	 * Method responsible for receiving the eidas Patient attributes from eIDAS HProxy
	 * 
	 * @param eidasAttributes
	 * 
	 * @return redirect the patient to AdditionalData Screen if other data are needed
	 * 		   otherwise redirect the patient to Consent/Acknowledge Screen
	 * 			
	 */
	
	@RequestMapping(value = EIDAS_PROXY_PATIENT_AUTH_URL, method = RequestMethod.POST,
			consumes = MediaType.APPLICATION_JSON_VALUE,
			produces = MediaType.TEXT_PLAIN_VALUE)
	@ResponseStatus(value = HttpStatus.OK)
	public String acceptPatientAuthNData(HttpServletRequest request, @RequestBody Map<String,String> eidasAttributes,
			RedirectAttributes redirectAttributes, ModelMap model) throws HealtheidGetCountryConfigurationException {

		String token = 
				request.getHeader("Authorization");
		
		String redirectPatient = 
				workflowManager.processEncounterData(token, request, eidasAttributes, redirectAttributes);	
		
		return redirectPatient;
	}

}
