package eu.europa.ec.healtheid.config;

import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.jndi.JndiTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@ComponentScan("eu.europa.ec.healtheid.")
@EnableJpaRepositories(basePackages = "eu.europa.ec.healtheid.repository")
public class PersistenceJNDIConfig {
	
	@Value("${spring.datasource.jndi-name}")
	private String mySQLJNDIName;
 
	@Autowired
	private Environment env;
	 
	
	@Bean
	public LocalContainerEntityManagerFactoryBean entityManagerFactory() throws NamingException {
		
	    final LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
	    em.setDataSource(dataSource());
	    em.setPackagesToScan("eu.europa.ec.healtheid.models");
	    em.setJpaVendorAdapter(new HibernateJpaVendorAdapter());
	    em.setJpaProperties(additionalProperties());
	    return em;
	 }

	 @Bean
	 public DataSource dataSource() throws NamingException {
		 /*MANUAL CONFIGURATION
		 DataSourceBuilder dataSourceBuilder = DataSourceBuilder.create();
	     dataSourceBuilder.driverClassName("com.mysql.cj.jdbc.Driver");
	     dataSourceBuilder.url("jdbc:mysql://localhost:3306/ehealth_healtheid?useTimezone=true&serverTimezone=UTC");
	     dataSourceBuilder.username("root");
	     dataSourceBuilder.password("password");
	     DataSource ds= dataSourceBuilder.build();*/
		 DataSource ds = (DataSource) new JndiTemplate().lookup(env.getProperty("spring.datasource.jndi-name"));
	    
	     return ds;
	 }

	 @Bean
	 public PlatformTransactionManager transactionManager(final EntityManagerFactory emf) {
	     return new JpaTransactionManager(emf);
	 }

	 @Bean
	 public PersistenceExceptionTranslationPostProcessor exceptionTranslation() {
	     return new PersistenceExceptionTranslationPostProcessor();
	 }

	 final Properties additionalProperties() {
	     final Properties hibernateProperties = new Properties();
	     hibernateProperties.setProperty("hibernate.hbm2ddl.auto", env.getProperty("spring.jpa.hibernate.ddl-auto"));
	     //hibernateProperties.setProperty("hibernate.dialect", env.getProperty("hibernate.dialect"));
	     //hibernateProperties.setProperty("hibernate.cache.use_second_level_cache", "false");
	     return hibernateProperties;
	 }
}
