package eu.europa.ec.healtheid.config;

import eu.europa.ec.healtheid.exception.PatientDataNotReadyException;
import eu.europa.ec.healtheid.models.ErrorResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class HealtheidExceptionHandler extends ResponseEntityExceptionHandler{
	
	private static final Logger LOGGER = LoggerFactory.getLogger(HealtheidExceptionHandler.class);
	
	@ExceptionHandler({Exception.class})
    public ResponseEntity<Object> handleAllException(Exception ex) {
		LOGGER.info("Exception: " + ex.getLocalizedMessage() );
        ErrorResponse response = new ErrorResponse.ErrorResponseBuilder()
		        .withStatus(HttpStatus.INTERNAL_SERVER_ERROR)
		        .withError_code("ERR_HEID_0001")
		        .withDescription("Internal Exception")
		        .build();
    
        return new ResponseEntity<>(response, response.getStatus());
    }
	
	@ExceptionHandler({PatientDataNotReadyException.class})
	protected ResponseEntity<Object> handlePatientDataNotReady(PatientDataNotReadyException ex) { 
		
		return new ResponseEntity<>(HttpStatus.NO_CONTENT);
	}

}






