package eu.europa.ec.healtheid.eidashproxy.services;

import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

@Service
public class EidasMappingService {

	private ConcurrentHashMap <String,String> encounterEidasMap = new ConcurrentHashMap <> ();


	public boolean valueExist(String samlID) {
		return encounterEidasMap.containsKey(samlID);
	  }
	
	 public String retrieveEncounterID(String samlID) {
	    return encounterEidasMap.get(samlID);
	  }
	 public HashMap<String, String> getFullMap() {
		    return new HashMap<String, String>(encounterEidasMap);
	  }
	 
	  public void storeEncounterID(String samlID, String encounterID){
		  encounterEidasMap.put(samlID, encounterID);
	  }
	  
	  public void removeSamlID(String samlID){
		  encounterEidasMap.remove(samlID);
	  }
}
