package eu.europa.ec.healtheid.eidashproxy;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@SpringBootApplication
@ComponentScan({"eu.eidas.sp", "eu.europa.ec.healtheid.eidashproxy"})
@PropertySources({
    @PropertySource(value={"classpath:default.properties"}),
    @PropertySource(value={"file:${eidas-hproxy.properties}"},ignoreResourceNotFound = true)
})
public class EidasHproxyApplication extends SpringBootServletInitializer{
	
	@Override
	protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(EidasHproxyApplication.class);
    }
	
	public static void main(String[] args) {
		SpringApplication.run(EidasHproxyApplication.class, args);
	}

}
