package eu.eidas.sp;

//import static eu.europa.ec.healtheid.config.HealtheidConnectorConstants.EIDAS_PROXY_BASE_URL;

import java.security.cert.X509Certificate;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.joda.time.DateTime;
import org.joda.time.DurationFieldType;
import org.opensaml.saml.common.xml.SAMLConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import eu.eidas.auth.engine.ProtocolEngineFactory;
import eu.eidas.auth.engine.ProtocolEngineI;
import eu.eidas.auth.engine.configuration.dom.ProtocolEngineConfigurationFactory;
import eu.eidas.auth.engine.metadata.ContactData;
import eu.eidas.auth.engine.metadata.EidasMetadata;
import eu.eidas.auth.engine.metadata.EidasMetadataParametersI;
import eu.eidas.auth.engine.metadata.EidasMetadataRoleParametersI;
import eu.eidas.auth.engine.metadata.MetadataConfiguration;
import eu.eidas.auth.engine.metadata.MetadataSignerI;
import eu.eidas.auth.engine.metadata.OrganizationData;
import eu.eidas.auth.engine.metadata.impl.MetadataRole;
import eu.eidas.engine.exceptions.EIDASMetadataException;
import eu.eidas.engine.exceptions.EIDASSAMLEngineException;

@Controller
@RequestMapping("/eidas-hproxy")
public class MetadataGenerator {
	private static final Logger LOGGER = LoggerFactory.getLogger(MetadataGenerator.class);
	
	//@Autowired
	//Properties configs;

    @Value("${eidas.path}")
    private String eidasConfigPath;  
    
    @Value("${sp.return}")
    private String spReturn; 
    
    @Value("${sp.type}")
    private String spType;  
    
    @Value("${sp.metadata.retention}")
    private String spMetadataRetention;  
    
    @Value("${encryption.algorithm.whitelist}")
    private String encryptionAlgorithmWhitelist;  
    
    @Value("${signature.algorithm.whitelist}")
    private String signatureAlgorithmWhitelist;  
    
    @Value("${sp.metadata.url}")
    private String metadataUrl;
    
    @Value("${contact.support.email}")
    private String contactSupportEmail;
    
    @Value("${contact.support.company}")
    private String contactSupportCompany;
    
    @Value("${contact.support.givenname}")
    private String contactSupportGivenname;
    
    @Value("${contact.support.surname}")
    private String contactSupportSurname;
    
    @Value("${contact.support.phone}")
    private String contactSupportPhone;
    
    @Value("${contact.technical.email}")
    private String contactTechnicalEmail;
    
    @Value("${contact.technical.company}")
    private String contactTechnicalCompany;
    
    @Value("${contact.technical.givenname}")
    private String contactTechnicalGivenname;
    
    @Value("${contact.technical.surname}")
    private String contactTechnicalSurname;
    
    @Value("${contact.technical.phone}")
    private String contactTechnicalPhone;
    
    @Value("${eidas.protocol.version}")
    private String eidasProtocolVersion;
    
    @Value("${eidas.application.identifier}")
    private String eidasApplicationIdentifier;
	
	private ProtocolEngineFactory SpProtocolEngineFactory;
	private ProtocolEngineConfigurationFactory SpProtocolEngineConfigurationFactory;
	private long validityDuration;
	
    private ProtocolEngineI setSPMetadataRoleParams(final EidasMetadataParametersI emp, final EidasMetadataRoleParametersI emrp) throws EIDASSAMLEngineException {
        emrp.setRole(MetadataRole.SP);
        emrp.setDefaultBinding(SAMLConstants.SAML2_POST_BINDING_URI);
        emrp.addProtocolBindingLocation(SAMLConstants.SAML2_POST_BINDING_URI, spReturn);
        emrp.addProtocolBindingLocation(SAMLConstants.SAML2_REDIRECT_BINDING_URI, spReturn);

        emp.setSpType(spType);
        
        SpProtocolEngineConfigurationFactory = new ProtocolEngineConfigurationFactory(Constants.SP_SAMLENGINE_FILE, null, eidasConfigPath);
        SpProtocolEngineFactory = new ProtocolEngineFactory(SpProtocolEngineConfigurationFactory);
        
        final ProtocolEngineI protocolEngine = SpProtocolEngineFactory.getProtocolEngine("SP");
        final X509Certificate spEngineDecryptionCertificate = protocolEngine.getDecryptionCertificate();
        if (spEngineDecryptionCertificate != null) {
            emrp.setEncryptionCertificate(spEngineDecryptionCertificate);
        }

        emrp.setSigningCertificate(protocolEngine.getSigningCertificate());
        return protocolEngine;
    }
    
    private DateTime metadataValidityDurationDuration(int seconds, ProtocolEngineI protocolEngine) {
        DateTime expiryDate = protocolEngine.getClock().getCurrentTime();
        validityDuration = Integer.parseInt(spMetadataRetention);
        return expiryDate.withFieldAdded(DurationFieldType.seconds(), (int) (validityDuration));
    }
    
	@RequestMapping(value = "/metadata", method = RequestMethod.GET, produces = { "application/xml", "text/xml" }, consumes = MediaType.ALL_VALUE )
	@ResponseBody
	public String generateMetadata(HttpServletRequest request){
		LOGGER.info("Metadata request from: " + request.getRemoteHost());
		String metadata="invalid metadata";
		if(true) {
			try {
				EidasMetadataParametersI emp = MetadataConfiguration.newParametersInstance();
                EidasMetadataRoleParametersI emrp = MetadataConfiguration.newRoleParametersInstance();
   
                final ProtocolEngineI protocolEngine;
                protocolEngine = setSPMetadataRoleParams(emp, emrp);
                emrp.setEncryptionAlgorithms(encryptionAlgorithmWhitelist);
                emrp.setWantAssertionsSigned(true);
                emp.setEntityID(metadataUrl);
                emp.setAssuranceLevel(null);
                emp.addRoleDescriptor(emrp);
                emp.setSigningMethods(signatureAlgorithmWhitelist);
                emp.setDigestMethods(signatureAlgorithmWhitelist);
                emp.setHideLoaType(true);
                emp.setValidUntil(metadataValidityDurationDuration(18000, protocolEngine));
                Properties ContactProperties = new Properties();
                ContactProperties.put("contact.support.email", contactSupportEmail);
                ContactProperties.put("contact.support.company", contactSupportCompany);
                ContactProperties.put("contact.support.givenname", contactSupportGivenname);
                ContactProperties.put("contact.support.surname", contactSupportSurname);
                ContactProperties.put("contact.support.phone", contactSupportPhone);
                ContactProperties.put("contact.technical.email", contactTechnicalEmail);
                ContactProperties.put("contact.technical.company", contactTechnicalCompany);
                ContactProperties.put("contact.technical.givenname", contactTechnicalGivenname);
                ContactProperties.put("contact.technical.surname", contactTechnicalSurname);
                ContactProperties.put("contact.technical.phone", contactTechnicalPhone);
                ContactData technicalContact = MetadataUtil.createConnectorTechnicalContact(ContactProperties);
                ContactData supportContact = MetadataUtil.createConnectorSupportContact(ContactProperties);
                OrganizationData organization = MetadataUtil.createConnectorOrganizationData(ContactProperties);
                emp.setTechnicalContact(technicalContact);
                emp.setSupportContact(supportContact);
                emp.setOrganization(organization);
                emp.setEidasProtocolVersion(eidasProtocolVersion);
                emp.setEidasApplicationIdentifier(eidasApplicationIdentifier);

                EidasMetadata.Generator generator = EidasMetadata.generator(emp);
                EidasMetadata eidasMetadata = generator.generate((MetadataSignerI) protocolEngine.getSigner());

                metadata = eidasMetadata.getMetadata();
                
            } catch (EIDASMetadataException eidasSamlexc) {
                System.out.println("ERROR : Error creating Node metadata " + eidasSamlexc.getMessage());
              

            } catch (EIDASSAMLEngineException eidasSamlexc) {
            	System.out.println("ERROR : Error creating Node metadata " + eidasSamlexc.getMessage());
            	

            }
		}
		//dataStream = new ByteArrayInputStream(EidasStringUtil.getBytes(metadata));
		return metadata;
	}
}
