package eu.eidas.sp;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.RestTemplate;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;

import eu.eidas.auth.commons.EidasStringUtil;
import eu.eidas.auth.commons.attribute.AttributeDefinition;
import eu.eidas.auth.commons.attribute.AttributeValue;
import eu.eidas.auth.commons.protocol.IAuthenticationResponse;
import eu.eidas.auth.engine.ProtocolEngineFactory;
import eu.eidas.auth.engine.ProtocolEngineI;
import eu.eidas.auth.engine.configuration.dom.ProtocolEngineConfigurationFactory;
import eu.eidas.engine.exceptions.EIDASSAMLEngineException;
import eu.europa.ec.healtheid.eidashproxy.services.EidasMappingService;

@Controller
@RequestMapping("/eidas-hproxy")
public class AuthResponse {

    @Value("${eidas.path}")
    private String eidasConfigPath;
    
    @Value("${sp.metadata.url}")
    private String metadataUrl;
    
	private static final Logger LOGGER = LoggerFactory.getLogger(AuthResponse.class);

	private static final String SAML_VALIDATION_ERROR = "Could not validate token for Saml Response";

	private ProtocolEngineConfigurationFactory SpProtocolEngineConfigurationFactory;
	private ProtocolEngineFactory SpProtocolEngineFactory;
	private ProtocolEngineI protocolEngine;

	private ImmutableMap<AttributeDefinition<?>, ImmutableSet<? extends AttributeValue<?>>> attrMap;
	
	@Autowired
	private EidasMappingService mappingSamlService;
	
	@Value("${url.heidConnector.acceptPatientAuth}")
	private String heidConnectorUrl;

	@RequestMapping(value = "/AuthResponse", method = RequestMethod.POST) 
	public void response(ModelMap model, @RequestParam String SAMLResponse, HttpServletRequest request) {
		LOGGER.info("eidas authentication response received");

		byte[] decSamlToken = EidasStringUtil.decodeBytesFromBase64(SAMLResponse);
		//samlResponseXML = EidasStringUtil.toString(decSamlToken);

		IAuthenticationResponse authnResponse;


		//Get SAMLEngine instance
		try {
			SpProtocolEngineConfigurationFactory = new ProtocolEngineConfigurationFactory(Constants.SP_SAMLENGINE_FILE, null, eidasConfigPath);
			SpProtocolEngineFactory = new ProtocolEngineFactory(SpProtocolEngineConfigurationFactory);
			protocolEngine = SpProtocolEngineFactory.getProtocolEngine("SP");
			//ProtocolEngineI engine = SpProtocolEngineFactory.getSpProtocolEngine(SP_CONF);
			//validate SAML Token
			authnResponse = protocolEngine.unmarshallResponseAndValidate(decSamlToken, request.getRemoteHost(), 0, 0, metadataUrl,null,false);
		} catch (EIDASSAMLEngineException e) {
			if (StringUtils.isEmpty(e.getErrorDetail(	))) {
				throw new ApplicationSpecificServiceException(SAML_VALIDATION_ERROR, e.getErrorMessage());
			} else {
				throw new ApplicationSpecificServiceException(SAML_VALIDATION_ERROR, e.getErrorDetail());
			}
		}

		if (authnResponse.isFailure()) {
			throw new ApplicationSpecificServiceException("Saml Response is fail", authnResponse.getStatusMessage());
		} 
			attrMap = authnResponse.getAttributes().getAttributeMap();
			Map<String, String> map = new HashMap<String,String>();
			for (AttributeDefinition<?> key : attrMap.keySet()){
				LOGGER.debug("key.getFriendlyName(): " + key.getFriendlyName() +
						"attrMap.get(key).toString(): " +attrMap.get(key).toString());
				map.put(key.getFriendlyName(), attrMap.get(key).toString());
			}
			
			LOGGER.debug("saml in response to: " + authnResponse.getInResponseToId());
			
			String samlID=authnResponse.getInResponseToId();
			
			if(!mappingSamlService.valueExist(samlID)) LOGGER.error("\n****Unknown samlID******\n");
			
			String token= mappingSamlService.retrieveEncounterID(samlID);
			LOGGER.debug("Patient token: " + token);
			
			LOGGER.info("Sending attributes to Workflow Manager");
			
			ResponseEntity<String> response=postWithToken(heidConnectorUrl, token,String.class, map);
			LOGGER.info("Response status code: " + response.getStatusCode());
			/*  
			model.addAttribute("attrMap", map);
			model.addAttribute("eIDASattrMap", map);
			model.addAttribute("jwtToken", authnResponse.getInResponseToId());
			//TODO: return new ModelAndView("redirect:"+heidConnectorUrl, model); 
			return new ModelAndView("result");
			*/		
	}
	
	public static <T> ResponseEntity<T> postWithToken(String endpointURI, String bearerToken, Class<T> responseType, Object requestData){

        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(bearerToken);
       
        HttpEntity<Object> entity = new HttpEntity<>(requestData, headers);
        ResponseEntity<T> response = restTemplate.postForEntity(endpointURI, entity, responseType);
        return response;
    }

}
