/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.healtheid.notification.adapter.service;

import eu.europa.ec.healtheid.notification.adapter.model.HealtheidNotification;
import eu.europa.ec.healtheid.notification.adapter.service.HealtheidNotifier;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class HealtheidNotifierImpl
implements HealtheidNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealtheidNotifierImpl.class);
    private JavaMailSender mailSender;
    @Value(value="${email.from}")
    private String emailFrom;

    @Autowired
    public HealtheidNotifierImpl(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public HealtheidNotification notify(HealtheidNotification healtheidNotification) {
        block4: {
            try {
                if (!healtheidNotification.getEmail().isEmpty()) {
                    this.notifyByEmail(healtheidNotification);
                    break block4;
                }
                if (!healtheidNotification.getSms().isEmpty()) {
                    this.notifyBySMS(healtheidNotification);
                    break block4;
                }
                throw new Exception("Email and SMS blank");
            }
            catch (Exception e) {
                LOGGER.info("Error sending the notification  " + e.getMessage());
            }
        }
        return healtheidNotification;
    }

    private void notifyByEmail(HealtheidNotification healtheidNotification) throws MessagingException {
        healtheidNotification.setNotificationSent(false);
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message);
        LOGGER.info("Mime message created");
        LOGGER.info("preparing link...");
        helper.setFrom(this.emailFrom);
        helper.setTo(healtheidNotification.getEmail());
        helper.setText(healtheidNotification.getMessage());
        helper.setSubject(healtheidNotification.getTitle());
        LOGGER.info("spring.mail.host  " + helper.getMimeMessage().getSession().getProperties());
        this.mailSender.send(message);
        healtheidNotification.setNotificationSent(true);
    }

    private void notifyBySMS(HealtheidNotification healtheidNotification) {
        LOGGER.info("This method is not implemented yet");
        healtheidNotification.setNotificationSent(false);
    }
}

