#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
void main(int argc, char** argv){
	struct timeval t1;
	gettimeofday(&t1, NULL);
	srand(t1.tv_usec * t1.tv_sec);
	if(argc != 6){
		fprintf(stderr, "USAGE: n_graphs graph_dim min_density max_density g_name\n");
		exit(1);
	}
	long int n = 0;
	long int s = 0;
	long int d_min = 0;
	long int d_max = 0;
	int ** adj_mat;
	int *degree;
	n = strtol(argv[1], NULL, 10);
	s = strtol(argv[2], NULL, 10);
	d_min = strtol(argv[3], NULL, 10);
	d_max = strtol(argv[4], NULL, 10);
	char *g_name = argv[5];
	long int complete_dim = s*(s-1)/2;
	degree = malloc(s * sizeof(int));
	adj_mat = malloc(s * sizeof(int*));
	for (int i = 0; i< s; i++) adj_mat[i] = malloc(s * sizeof(int));
	int e1, e2;
	for(int k = 0; k < n; k++){
		int d = rand()%(d_max-d_min) + d_min;
		long int _d = complete_dim*d /10;
		for(int i = 0; i < s; i++) degree[i] = 0;
		for(int i = 0; i < s; i++) for(int j = 0; j < s; j++) adj_mat[i][j] = 0;
		for(int a = 0; a < _d; a++){
			do{
				do{				
				e1 = rand()%s;
				e2 = rand()%s;
				}while(e1==e2);
			}while(adj_mat[e1][e2] != 0);
			degree[e1]++;
			adj_mat[e1][e2] = 1;
		}
		char filename[64];
		switch(d_min){
			case 2:
				sprintf(filename, "rand_lo_s%02ld.%s%02d.ladder", s, g_name, k);
				break;
			case 4:
				sprintf(filename, "rand_mi_s%02ld.%s%02d.ladder", s, g_name, k);
				break;
			default:
				sprintf(filename, "rand_hi_s%02ld.%s%02d.ladder", s, g_name, k);
		}
		FILE* out = fopen(filename, "w+");
		fprintf(out, "%ld\n", s);
		for(int i = 0; i < s; i++){
			fprintf(out, "%d ", degree[i]);
			for(int j = 0; j < s; j++) if (adj_mat[i][j] > 0) fprintf(out, "%d ", j);
			fprintf(out, "\n");
		}
	}
}
