set terminal eps enhanced font "Times New Roman,14" size 3.2,3
set output "plot_it.eps"
set datafile separator ","
set style line 102 lc rgb '#a0a0a0' lt 1 lw 1
set border ls 102
set colorbox border 102
set key textcolor rgb "black"
set key font ",14"
set xtics font ",14"
set ytics font ",14"
set xlabel font ",14"
set ylabel font ",14"
set tics textcolor rgb "black"
set label textcolor rgb "black"
set size square
set xrange [1e-4:10]
set yrange [0: 2750]
set xlabel "Runtime (s)"
set ylabel "Number solved"
set logscale x
set border 3
set grid
set xtics nomirror
set ytics nomirror
set key bottom right
set format x '10^{%T}'
set ytics add ('2750' 2750)
plot  \
	"../results/timeout_10/total.csv" u 8:($8>=1e6?1e-10:1) smooth cumulative w l ti 'v3' lt rgb "gray" lw 3, \
	"../results/timeout_10/total.csv" u 9:($9>=1e6?1e-10:1) smooth cumulative w l ti 'v4' lt rgb "dark-gray" lw 3
