set terminal eps enhanced font "Times New Roman,14" size 4.2,4
set output "plot_all.eps"
set datafile separator ","
set style line 102 lc rgb '#a0a0a0' lt 1 lw 1
set border ls 102
set colorbox border 102
set key textcolor rgb "black"
set key font ",14"
set xtics font ",12"
set ytics font ",12"
set xlabel font ",16"
set ylabel font ",16"
set tics textcolor rgb "black"
set label textcolor rgb "black"
set size square
set xrange [1e-3:1e1]
set yrange [0: 2750]
set xlabel "Runtime (s)"
set ylabel "Number solved"
set logscale x
set border 3
set grid
set xtics nomirror
set ytics nomirror
set key bottom right
set format x '10^{%T}'
set ytics add ('2750' 2750)
plot  \
	"../results/timeout_10/total.csv" u 4:($4>=1e6?1e-10:1) smooth cumulative with lines title 'v0.1' lc rgb "cyan" lw 3, \
	"../results/timeout_10/total.csv" u 5:($5>=1e6?1e-10:1) smooth cumulative with lines title 'v0.2' lc rgb "blue" lw 3, \
	"../results/timeout_10/total.csv" u 6:($6>=1e6?1e-10:1) smooth cumulative with lines title 'v1' lc rgb "orange" lw 3, \
	"../results/timeout_10/total.csv" u 7:($7>=1e6?1e-10:1) smooth cumulative with lines title 'v2' lc rgb "red" lw 3, \
	"../results/timeout_10/total.csv" u 8:($8>=1e6?1e-10:1) smooth cumulative with lines title 'v3' lc rgb "gray" lw 3, \
	"../results/timeout_10/total.csv" u 9:($9>=1e6?1e-10:1) smooth cumulative with lines title 'v4' lc rgb "dark-gray" lw 3, \
	"../results/timeout_10/total.csv" u 10:($10>=1e6?1e-10:1) smooth cumulative with lines title 'v5' lc rgb "green" lw 3
